<?php
/**
 * ServiceProvider.php 2020-3-24
 * Gambio GmbH
 * http://www.gambio.de
 * Copyright (c) 2020 Gambio GmbH
 * Released under the GNU General Public License (Version 2)
 * [http://www.gnu.org/licenses/gpl-2.0.html]
 */

declare(strict_types=1);

namespace Gambio\Shop\SellingUnit\Presentation;

use Gambio\Shop\SellingUnit\Presentation\ValueObjects\OutOfStockMarkings;
use League\Container\Container;
use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Container\ServiceProvider\BootableServiceProviderInterface;

/**
 * Class ServiceProvider
 * @package Gambio\Shop\SellingUnit\Presentation
 * @property-read Container $container
 */
class ServiceProvider extends AbstractServiceProvider implements BootableServiceProviderInterface
{
    protected $provides = [
        OutOfStockMarkings::class
    ];
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->container->share(OutOfStockMarkings::class)->addArgument(STOCK_MARK_PRODUCT_OUT_OF_STOCK);
    }
    
    
    /**
     * @inheritDoc
     */
    public function boot(): void
    {
    
    }
}